-- View: v_pdv_vd_est_prod

DROP VIEW v_pdv_vd_est_prod;

CREATE OR REPLACE VIEW v_pdv_vd_est_prod AS 
 SELECT est_prod.ds_prod,
    est_prod_cpl.cd_emp,
    est_prod_cpl.cd_filial,
    est_prod_cpl.cd_prod,
    est_prod_cpl.qt_est,
    est_prod_cpl.cd_trib_vd,
    est_prod_cpl.perc_icms_n_cont_esta,
    est_prod_cpl.perc_red_vd,
    est_prod_cpl.perc_fcp,
    est_prod_cpl.cd_benef,
    NULLIF(est_prod_preco.vlr_tabela, 0::numeric) AS vlr_tabela,
    NULLIF(est_prod_preco.vlr_oferta, 0::numeric) AS vlr_oferta,
    est_trib.cd_trib_fc,
    est_prod_cpl.tp_prod,
    est_prod_cpl.qtde_ponto_fidel,
    est_prod.flag_prod_kit,
    NULLIF(est_prod_cpl.perc_ibpt, 0::numeric) AS tx_imposto,
    COALESCE(est_prod.ncm_prod, ''::character varying) AS ncm_prod,
    COALESCE(est_prod_cpl.icms, 0::numeric) AS icms,
    COALESCE(est_prod_cpl.subs_trib, 0::numeric) AS subs_trib,
    COALESCE(est_prod_cpl.icms_rd, 0::numeric) AS icms_rd,
    COALESCE(est_prod_cpl.isento, 0::numeric) AS isento,
    COALESCE(est_prod_cpl.subs_trib_ant, 0::numeric) AS subs_trib_ant,
    COALESCE(est_prod_cpl.flag_outros, 0::numeric) AS flag_outros,
    COALESCE(est_trib.tipo_regime_empresa::numeric, 0::numeric) AS tipo_regime_empresa
   FROM est_prod
     JOIN est_prod_cpl ON est_prod.cd_emp = est_prod_cpl.cd_emp AND est_prod.cd_prod = est_prod_cpl.cd_prod
     JOIN est_trib ON est_prod_cpl.cd_trib_vd = est_trib.cd_trib
     LEFT JOIN est_prod_preco ON est_prod_cpl.cd_emp = est_prod_preco.cd_emp AND est_prod_cpl.cd_filial = est_prod_preco.cd_filial AND est_prod_cpl.cd_prod = est_prod_preco.cd_prod;

ALTER TABLE v_pdv_vd_est_prod
  OWNER TO postgres;
